/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.variable;


import java.util.LinkedList;
import java.util.List;

import cfg.IrElement;
import cfg.IrType;
import cfg.Memory;

public class StackVariable implements Memory {
  private long offset;

  public StackVariable(long offset) {
    super();
    this.offset = offset;
  }

  public long getOffset() {
    return offset;
  }

  @Override
  public String toString() {
    return "stack" + offset;
  }

  public IrType getIrType() {
    return IrType.Memory;
  }

  public List<? extends IrElement> getChildren() {
    return new LinkedList<IrElement>();
  }
}
