/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package codewriter;

import java.util.Map;
import java.util.Set;

import ast.statement.Statement;

public class DataFlowInfo<T, P> implements InfoWriter {
  private Map<Statement, T> mapping;
  private Map<T, Set<P>>    in;
  private Map<T, Set<P>>    out;

  public DataFlowInfo(Map<Statement, T> mapping, Map<T, Set<P>> in, Map<T, Set<P>> out) {
    this.mapping = mapping;
    this.in = in;
    this.out = out;
  }

  public String get(Statement obj) {
    T key =  mapping.get(obj);
    return in.get(key) + " | " + out.get(key);
  }

}
