/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package dataflow;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.jgrapht.DirectedGraph;


public abstract class DataFlowLooper<V, E> {
  protected Map<DfVertex<V>, Set<V>>      in  = new HashMap<DfVertex<V>, Set<V>>();
  protected Map<DfVertex<V>, Set<V>>      out = new HashMap<DfVertex<V>, Set<V>>();
  protected DirectedGraph<DfVertex<V>, E> graph;

  public DataFlowLooper(DirectedGraph<DfVertex<V>, E> graph) {
    super();
    this.graph = graph;
  }

  public final Map<DfVertex<V>, Set<V>> getIn() {
    return in;
  }

  public final Map<DfVertex<V>, Set<V>> getOut() {
    return out;
  }

  public void process() {
    init();

    boolean change;
    do {
      change = false;
      for (DfVertex<V> v : graph.vertexSet()) {
        if (processBlock(v)) {
          change = true;
        }
      }
    } while (change);
  }

  abstract protected boolean processBlock(DfVertex<V> n);

  abstract protected void init();
}
