/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package dataflow.livevar;

import java.util.HashSet;
import java.util.Set;

import ast.PrgFunc;
import ast.expression.Expression;
import ast.statement.AssignmentStmt;
import ast.statement.CallStmt;
import ast.statement.CaseStmt;
import ast.statement.DoWhile;
import ast.statement.IfStmt;
import ast.statement.NullStmt;
import ast.statement.RetStmt;
import ast.statement.VarDef;
import ast.statement.WhileStmt;
import ast.traverser.VariableAccessCollector;
import ast.variable.Variable;
import dataflow.AstBlock;
import dataflow.GraphBuilder;

public class LiveVarGb extends GraphBuilder<Variable> {
  private final Set<Variable> empty = new HashSet<Variable>();

  protected Set<Variable> getVarRef(Expression expr) {
    VariableAccessCollector collector = new VariableAccessCollector();
    collector.visit(expr, null);
    return collector.getReferenced();
  }

  @Override
  protected AstBlock<Variable> createVertex() {
    return new AstBlock<Variable>(empty, empty, empty);
  }

  @Override
  protected AstBlock<Variable> createVertex(NullStmt obj) {
    return new AstBlock<Variable>(empty, empty, empty);
  }

  @Override
  protected AstBlock<Variable> createVertex(VarDef obj) {
    return new AstBlock<Variable>(empty, empty, empty);
  }

  @Override
  protected AstBlock<Variable> createVertex(CallStmt obj) {
    return new AstBlock<Variable>(empty, getVarRef(obj.getCall()), empty);
  }

  @Override
  protected AstBlock<Variable> createVertex(AssignmentStmt obj) {
    Set<Variable> def = getVarRef(obj.getDestination());
    return new AstBlock<Variable>(def, getVarRef(obj.getSource()), def);
  }

  @Override
  protected AstBlock<Variable> createVertex(RetStmt obj) {
    return new AstBlock<Variable>(empty, getVarRef(obj.getRetval()), empty);
  }

  @Override
  protected AstBlock<Variable> createVertex(IfStmt obj) {
    return new AstBlock<Variable>(empty, getVarRef(obj.getCondition()), empty);
  }

  @Override
  protected AstBlock<Variable> createVertex(CaseStmt obj) {
    return new AstBlock<Variable>(empty, getVarRef(obj.getCondition()), empty);
  }

  @Override
  protected AstBlock<Variable> createVertex(WhileStmt obj) {
    return new AstBlock<Variable>(empty, getVarRef(obj.getCondition()), empty);
  }

  @Override
  protected AstBlock<Variable> createVertex(DoWhile obj) {
    return new AstBlock<Variable>(empty, getVarRef(obj.getCondition()), empty);
  }

  @Override
  protected AstBlock<Variable> createVertex(PrgFunc obj) {
    return new AstBlock<Variable>(obj.getParam(), empty, obj.getParam());
  }

}
