package disassembler.diStorm3;

import util.NumPrint;

public class Operand {

	public enum OperandType {
		None, Reg, Imm, Imm1, Imm2, Disp, Smem, Mem, Pc, Ptr
	}

	private int mType;
	private int mIndex;
	private int mSize;

	public OperandType getType() {
		return OperandType.values()[mType];
	}

	public int getIndex() {
		return mIndex;
	}

	public int getSize() {
		return mSize;
	}
	
	private String signedHex( long value ){
		return NumPrint.toString(Math.abs(value));
	}
	
	private String ptrString( int size ){
		switch( size ){
		case 0:{
			return "";
		}
		case 8:{
			return "BYTE PTR";
		}
		case 16:{
			return "WORD PTR";
		}
		case 32:{
			return "DWORD PTR";
		}
		case 64:{
			return "QWORD PTR";
		}
		default:{
			assert( false );
			return null;
		}
		}
	}
	
	public String getPretty( DecomposedInst inst ){
		switch( getType() ){
		case Reg:{
			return Registers.values()[mIndex].toString();
		}
		case Imm:{
			return NumPrint.toString(inst.mImm.getImm());
		}
		case Disp:{
			return ptrString( mSize ) + " " + Registers.getDisplacementReg(mIndex).toString() + ":" + NumPrint.toString(inst.mDisp.getDisplacement());
		}
		case Smem:{
			String res;
			res = ptrString( mSize );
			res += " [";
			res += Registers.values()[mIndex].toString();
			res += signedHex(inst.mDisp.getDisplacement());
			res += "]";
			return res;
		}
		case Pc:{
			return NumPrint.toString(inst.mImm.getImm()+inst.getAddress()+inst.getSize());
		}
		case Mem:{
			String res;
			res = " [";
			if( inst.getBase() < Registers.values().length ){
				res += Registers.values()[inst.getBase()].toString();
				res += "+";
			}
			res += Registers.values()[mIndex].toString();
			res += "*";
			res += Math.max(inst.getScale(),1);	//FIXME make it correct, how is multiplicator of 1 defined?
			res += signedHex(inst.mDisp.getDisplacement());
			res += "]";
			return res;
		}
		default:{
			assert( false );
			return null;
		}
		}
	}

	@Override
	public boolean equals(Object obj) {
		if( !(obj instanceof Operand) ){
			return false;
		}
		return (((Operand)obj).mIndex == mIndex) && (((Operand)obj).mSize == mSize) && (((Operand)obj).mType == mType);
	}
	
	
}
