package elffile;

import java.io.IOException;
import java.io.RandomAccessFile;

/**
 * Created: Mar 20, 2010
 * <p/>
 * Part of Frida IRE. Copyright (c) 2010, Karl Trygve Kalleberg, Ole André Vadla Ravnås Licensed under the GNU General
 * Public License, v3
 * 
 * @author: karltk@boblycat.org
 */
public class ELFFile {
  private ELFHeader     header           = null;
  private ProgramHeader programHeaders[] = null;
  private SectionHeader sectionHeaders[] = null;

  public static ELFFile loadFromStream(RandomAccessFile ins) throws IOException {
    final ELFStreamReader esr = new ELFStreamReader(ins);
    ELFFile r = new ELFFile();
    r.header = ELFHeader.loadFromStream(esr);

    esr.seek(r.header.phoff);
    r.programHeaders = new ProgramHeader[r.header.phnum];
    for (int i = 0; i < r.header.phnum; i++) {
      r.programHeaders[i] = ProgramHeader.loadFromStream(esr);
    }
    r.sectionHeaders = new SectionHeader[r.header.shnum];

    esr.seek(r.header.shoff);
    for (int i = 0; i < r.header.shnum; i++) {
      r.sectionHeaders[i] = SectionHeader.loadFromStream(esr);
    }

    assert ((r.header.getShtstrndx() >= 0) && (r.header.getShtstrndx() < r.header.shnum));
    for (int i = 0; i < r.header.shnum; i++) {
      r.sectionHeaders[i].setName(esr.getName(r.sectionHeaders[i].getNameNr(), r));
    }

    return r;
  }

  public void dump() {
    header.dump();
    for (int i = 0; i < programHeaders.length; i++)
      programHeaders[i].dump();
    for (SectionHeader sec : sectionHeaders)
      sec.dump();
  }

  public ProgramHeader[] getProgramHeaders() {
    return programHeaders;
  }

  public SectionHeader[] getSectionHeaders() {
    return sectionHeaders;
  }

  public SectionHeader getSection(String name) {
    for (SectionHeader sec : sectionHeaders) {
      if (sec.getName().equals(name)) {
        return sec;
      }
    }
    assert (false);
    return null;
  }

  public ELFHeader getHeader() {
    return header;
  }

}
