package elffile;

import java.io.IOException;
import java.io.RandomAccessFile;

/**
 * Created: Mar 19, 2010
 * <p/>
 * Part of Frida IRE. Copyright (c) 2010, Karl Trygve Kalleberg, Ole André Vadla Ravnås Licensed under the GNU General
 * Public License, v3
 * 
 * @author: karltk@boblycat.org
 */
public class ELFStreamReader {
  private final RandomAccessFile ins;
  private int                    offset = 0;

  public ELFStreamReader(RandomAccessFile ins) {
    this.ins = ins;
  }

  public byte[] readUChar(int n) throws IOException {
    final byte[] r = new byte[n];
    for (int i = 0; i < n; i++) {
      r[i] = new Byte((byte) read());
    }
    return r;
  }

  // FIXME assume little-endian. correct?
  public short readE32Half() throws IOException {
    final short lsb = (short) (read() & 0xFF);
    final short msb = (short) (read() & 0xFF);
    return (short) ((msb << 8) | lsb);
  }

  public int readE32Word() throws IOException {
    final int b0 = read() & 0xFF;
    final int b1 = read() & 0xFF;
    final int b2 = read() & 0xFF;
    final int b3 = read() & 0xFF;

    return b3 << 24 | b2 << 16 | b1 << 8 | b0;
  }

  private int read() throws IOException {
    offset++;
    return ins.read();
  }

  public int readE32Addr() throws IOException {
    return readE32Word();
  }

  public int readE32Off() throws IOException {
    return readE32Word();
  }

  public void seek(int seekTo) throws IOException {
    ins.seek(seekTo);
  }

  public int getOffset() {
    return offset;
  }
  
  public String readString( int ofs ) {
    try {
      int oldofs = offset;
      seek(ofs);
      String res = "";
      byte sym;
      while ((sym = readUChar(1)[0]) != '\0') {
        res += (char) sym;
      }
      offset = oldofs;
      seek(offset);
      return res;
    } catch (IOException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
      return null;
    }
  }
  
  public String getName(int idx, ELFFile elf) {
    assert (elf.getHeader().getShtstrndx() >= 0);
    assert (elf.getHeader().getShtstrndx() < elf.getHeader().shnum);
    SectionHeader shead = elf.getSectionHeaders()[elf.getHeader().getShtstrndx()];

    assert (idx >= 0);
    assert (idx < shead.size());

    try {
      int oldofs = offset;
      seek(shead.offset() + idx);
      String res = "";
      byte sym;
      while ((sym = readUChar(1)[0]) != '\0') {
        res += (char) sym;
      }
      offset = oldofs;
      seek(offset);
      return res;
    } catch (IOException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
      return null;
    }
  }

}
