/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package elfreader;

import java.io.IOException;
import java.io.RandomAccessFile;

import elffile.ELFFile;
import elffile.SectionHeader;

public class ElfReader {
  private ELFFile          elfHeader;
  private RandomAccessFile file;
  private long             offset = -1;

  public ElfReader(RandomAccessFile file) throws IOException {
    super();
    this.file = file;
    this.elfHeader = ELFFile.loadFromStream(file);
  }

  public RandomAccessFile getFile() {
    return file;
  }

  public ELFFile getElfHeader() {
    return elfHeader;
  }

  public void seek(long offset) {
    getSection(offset);
    this.offset = offset;
  }

  public byte getByte() {
    SectionHeader sec = getSection(offset);

    long fofs = sec.toFileOffset(offset);

    offset++;
    try {
      file.seek(fofs);
      return file.readByte();
    } catch (IOException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
      return 0;
    }
  }

  public byte[] getBytes(int count) {
    byte res[] = new byte[count];
    SectionHeader sec = getSection(offset);
    long fofs = sec.toFileOffset(offset);
    offset += count;
    try {
      file.seek(fofs);
      for (int i = 0; i < count; i++) {
        res[i] = file.readByte();
      }
    } catch (IOException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
      return null;
    }
    return res;
  }

  private SectionHeader getSection(long offset) {
    for (SectionHeader sec : elfHeader.getSectionHeaders()) {
      if (sec.isInSection(offset)) {
        return sec;
      }
    }
    assert (false);
    return null;
  }

  private int readE32Word() throws IOException {
    SectionHeader sec = getSection(offset);
    long fofs = sec.toFileOffset(offset);
    file.seek(fofs);
    final int b0 = read() & 0xFF;
    final int b1 = read() & 0xFF;
    final int b2 = read() & 0xFF;
    final int b3 = read() & 0xFF;

    return b3 << 24 | b2 << 16 | b1 << 8 | b0;
  }

  private int read() throws IOException {
    offset++;
    return file.read();
  }

  public int getInt() {
    try {
      return readE32Word();
    } catch (IOException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
    return 0;
  }

  public boolean isText(long addr) {
    throw new RuntimeException("Not yet implemented");
  }

  public String readString() {
    String res = "";
    byte sym;
    while ((sym = getByte()) != '\0') {
      res += (char) sym;
    }
    return res;
  }
}
