/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package elfreader;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import elffile.ELFStreamReader;
import elffile.SectionHeader;

public class ElfRelocationReader {
  static public Map<Long, String> getFuncNames(ElfReader file) {
    HashMap<Long, String> res = new HashMap<Long, String>();
    for (SectionHeader sec : file.getElfHeader().getSectionHeaders()) {
      getFunctions(sec, file, res);
    }
    return res;
  }

  private static void getFunctions(SectionHeader sec, ElfReader file, HashMap<Long, String> res) {
    if (sec.getType() != SectionHeader.SHT_REL) {
      return;
    }
    // System.out.println("Found relocation info in section " + sec.getName());
    ELFStreamReader reader = new ELFStreamReader(file.getFile());
    try {
      SectionHeader symtab = file.getElfHeader().getSection(".dynsym");
      SectionHeader strtab = file.getElfHeader().getSection(".dynstr");

      assert ((sec.size() % 8) == 0);
      for (int i = 0; i < sec.size(); i += 8) {
        reader.seek(sec.offset() + i);
        readEntry(reader, file, symtab.getOffset(), strtab.getOffset(), res);
      }
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  private static void readEntry(ELFStreamReader file, ElfReader reader, int offset, int strtabOfs,
      HashMap<Long, String> res) throws IOException {
    long addr = file.readE32Off();
    long info = file.readE32Off();

    int sym = (int) (info >> 8);
//    int type = (int) (info & 0xff);

    file.seek(offset + 16 * sym);
    long st_name = file.readE32Word();
/*    long st_value = file.readE32Addr();
    long st_size = file.readE32Word();
    long st_info = file.readUChar(1)[0];
    long st_other = file.readUChar(1)[0];
    long st_shndx = file.readE32Half();*/

    reader.seek( addr );
    long stubaddr = reader.getInt() - 6;    //TODO why -6? I mean it is needed, but why?
    
    String sname = file.readString((int) (strtabOfs + st_name));
    // System.out.println(NumPrint.toString(stubaddr) + " " + sname + " " + type );

    res.put(stubaddr, sname);
  }
}
