/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package graph.algorithm;

import org.jgrapht.DirectedGraph;

public class FindEntry {
  public static <V, E> V getEntry(DirectedGraph<V, E> g) {
    V entry = null;
    for (V v : g.vertexSet()) {
      if (g.inDegreeOf(v) == 0) {
        if (entry != null) {
          throw new RuntimeException("Only 1 entry point allowed");
        }
        entry = v;
      }
    }
    if (entry == null) {
      throw new RuntimeException("Entry point not found");
    }
    return entry;
  }

}
