/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package graphviz;

import java.io.PrintStream;

import org.jgrapht.Graph;

public class DotSimpleWriter<V, E> extends DotWriter<V, E> {
  private LabelWriter<V, E> vw;

  public DotSimpleWriter(LabelWriter<V, E> vw, Graph<V, E> g) {
    super(g);
    this.vw = vw;
  }

  protected void writeVertex(V v, PrintStream stream) {
    stream.print("  ");
    stream.print(getId(v) + "[ ");
    stream.print("label=\"");
    vw.writeVertexLabel(v, stream);
    stream.print("\"]; ");
    stream.println();
  }

  protected void writeEdge(E e, PrintStream stream) {
    stream.print("  ");
    stream.print(getId(g.getEdgeSource(e)));
    if( isDirected() ){
      stream.print(" -> ");
    } else {
      stream.print(" -- ");
    }
    stream.print(getId(g.getEdgeTarget(e)));
    stream.print(" [ label=\"");
    vw.writeEdgeLabel(e, stream);
    stream.print("\" ]");
    stream.println();
  }

  private String getId(V bb) {
    return "_" + Long.toHexString(bb.hashCode());
  }

  @Override
  protected String getNodeShape() {
    return "rect";
  }

}
