/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package graphviz.depgraph;


import org.apache.commons.lang.StringEscapeUtils;

import util.NumPrint;
import cfg.function.PrgFunction;
import cfg.statement.Statement;
import codewriter.Writer;

abstract public class GraphWriter {
  private Writer wr;
  private static final String[] style = { "solid", "dashed", "dotted", "invis", "bold", "tapered" };

  protected void wrFooter() {
    wr.decIndent();
    wr.wr("}");
    wr.nl();
  }

  protected void wrHeader(PrgFunction func) {
    wr.wr("digraph \"");
    wr.wr(NumPrint.toString(func.getAddr()));
    wr.wr("\" {");
    wr.nl();
    wr.incIndent();
    wr.wr("node [ shape=rect ]");
    wr.nl();
    wr.nl();
  }

  public GraphWriter(Writer wr) {
    super();
    this.wr = wr;
  }

  protected void wrEdge(Statement src, Statement dst, int type) {
    wr.wr(getId(src));
    wr.wr(" -> ");
    wr.wr(getId(dst));
    wr.wr( " [style=\"" );
    wr.wr( style [type] );
    wr.wr( "\"]" );
    wr.nl();
  }

  protected void wrVertex(Statement obj) {
    wr.wr(getId(obj) + "[ ");
    wr.wr("label=\"");
    wr.wr( Integer.toString(obj.getNumber()) );
    wr.wr(": ");
    wr.wr(escape(obj.toString()));
    wr.wr("\"]; ");
    wr.nl();
  }

  private String escape(String text) {
    return StringEscapeUtils.escapeHtml(text);
  }

  private String getId(Object obj) {
    return "_" + obj.hashCode();
  }

}
