/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge;

import cfg.statement.Statement;

public class KnowDeletable extends KnowledgeEntry {
  private KnowMemAccess kma;

  @Override
  public void init(KnowledgeBase base) {
    kma = (KnowMemAccess) base.getEntry(KnowMemAccess.class);
  }

  public boolean isDeletable(Statement stmt) {
    switch (stmt.getIrType()) {
      case JumpStmt:
      case RetStmt:
        return false;
      case NopStmt:
      case PhiStmt:
        return true;
      case AssignmentStmt:
        return !kma.doesWrite(stmt);
      default: {
        throw new RuntimeException("Unhandled type: " + stmt.getIrType());
      }
    }
  }

}
