/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge;


import java.util.HashSet;

import cfg.IntConstant;
import cfg.IrTraverser;
import cfg.variable.ArrayAccess;
import cfg.variable.Variable;
import cfg.variable.VariablePtrOf;

public class KnowDynamicArrayAccess extends KnowledgeEntry {
  private HashSet<Variable> dynamicAccess = new HashSet<Variable>();

  @Override
  public void init(KnowledgeBase base) {
    KnowDynamicArrayAccessVisitor visitor = new KnowDynamicArrayAccessVisitor(dynamicAccess);
    visitor.visit(base.getApp().getFunctions(), null);
  }

  public boolean hasDynamicAccess(Variable array) {
    return dynamicAccess.contains(array);
  }

}

class KnowDynamicArrayAccessVisitor extends IrTraverser<Void, Void> {
  private HashSet<Variable> dynamicAccess;

  public KnowDynamicArrayAccessVisitor(HashSet<Variable> dynamicAccess) {
    super();
    this.dynamicAccess = dynamicAccess;
  }

  @Override
  protected Void visitVariablePtrOf(VariablePtrOf obj, Void param) {
    assert (obj.getExpression() instanceof ArrayAccess);
    ArrayAccess var = (ArrayAccess) obj.getExpression();
    dynamicAccess.add(var.getBase());
    return null;
  }

  @Override
  protected Void visitVariableArrayAccess(ArrayAccess obj, Void param) {
    if (!(obj.getIndex() instanceof IntConstant)) {
      dynamicAccess.add((Variable) obj.getBase());
      super.visitVariableArrayAccess(obj, param);
    }
    return null;
  }

}
