/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge;


import java.util.Collection;

import cfg.BooleanConstant;
import cfg.IntConstant;
import cfg.IrElement;
import cfg.IrTraverser;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.expression.CallExprLinked;
import cfg.expression.CallExprPointer;
import cfg.expression.CallExprUnlinked;
import cfg.expression.CompareExpr;
import cfg.expression.IfExpr;
import cfg.expression.IntegerExpr;
import cfg.expression.UnaryExpression;
import cfg.expression.VariableKilled;
import cfg.expression.VariableRefLinked;
import cfg.expression.VariableRefUnlinked;
import cfg.function.Function;
import cfg.function.LibFunction;
import cfg.function.PrgFunction;
import cfg.function.SysFunction;
import cfg.statement.AssignmentStmt;
import cfg.statement.JumpStmt;
import cfg.statement.NopStmt;
import cfg.statement.PhiStmt;
import cfg.statement.RetStmt;
import cfg.statement.Statement;
import cfg.variable.Array;
import cfg.variable.ArrayAccess;
import cfg.variable.GlobalVariable;
import cfg.variable.SsaVariable;
import cfg.variable.StackVariable;
import cfg.variable.Variable;
import cfg.variable.VariablePtrDeref;
import cfg.variable.VariablePtrOf;

public class KnowEqual extends KnowledgeEntry {

  @Override
  public void init(KnowledgeBase base) {
  }

  public boolean equal(Statement stmt1, Statement stmt2) {
    KnowEqualVisitor visitor = new KnowEqualVisitor();
    return visitor.visit(stmt1, stmt2);
  }

}

class KnowEqualVisitor extends IrTraverser<Boolean, Object> {

  @Override
  protected Boolean visitBbEdge(BbEdge obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitSsaVariable(SsaVariable obj, Object param) {
    return obj.getName().equals(((Variable) param).getName());
  }

  @Override
  protected Boolean visitArray(Array obj, Object param) {
    return obj.getName().equals(((Variable) param).getName());
  }

  @Override
  protected Boolean visitBasicBlock(BasicBlock obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitStatement(Statement obj, Object param) {
    return true;
  }

  @Override
  protected Boolean visitAssignmentStmt(AssignmentStmt obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitFunction(Function obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitSysFunction(SysFunction obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitPrgFunction(PrgFunction obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitLibFunction(LibFunction obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitCollection(Collection<IrElement> obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitCallExprLinked(CallExprLinked obj, Object param) {
    return obj.getFunc() == ((CallExprLinked) param).getFunc();
  }

  @Override
  protected Boolean visitCallExprUnlinked(CallExprUnlinked obj, Object param) {
    return obj.getAddr() == ((CallExprUnlinked) param).getAddr();
  }

  @Override
  protected Boolean visitCallExprPointer(CallExprPointer obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitUnaryExpression(UnaryExpression obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitPhiStmt(PhiStmt obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitVariableRefUnlinked(VariableRefUnlinked obj, Object param) {
    return obj.getName() == ((VariableRefUnlinked) param).getName();
  }

  @Override
  protected Boolean visitVariableRefLinked(VariableRefLinked obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitVariableKilled(VariableKilled obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitBooleanConstant(BooleanConstant obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitConstant(IntConstant obj, Object param) {
    return obj.getValue() == ((IntConstant) param).getValue();
  }

  @Override
  protected Boolean visitVariablePtrOf(VariablePtrOf obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitVariableArrayAccess(ArrayAccess obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitVariablePtrDeref(VariablePtrDeref obj, Object param) {
    return true;
  }

  @Override
  protected Boolean visitStackVariable(StackVariable obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitGlobalVariable(GlobalVariable obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitIfExpr(IfExpr obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitIntegerExpr(IntegerExpr obj, Object param) {
    return obj.getOp() == ((IntegerExpr) param).getOp();
  }

  @Override
  protected Boolean visitCompareExpr(CompareExpr obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitRetStmt(RetStmt obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitJumpStmt(JumpStmt obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Boolean visitNopStmt(NopStmt obj, Object param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  public Boolean visit(Object obj, Object param) {
    if ((obj instanceof IrElement) != (param instanceof IrElement)) {
      return false;
    }
    if (obj instanceof IrElement) {
      IrElement irobj = (IrElement) obj;
      IrElement irparam = (IrElement) param;
      if (irobj.getIrType() != irparam.getIrType()) {
        return false;
      }
      if (irobj.getChildren().size() != irparam.getChildren().size()) {
        return false;
      }
      if (!super.visit(irobj, irparam)) {
        return false;
      }
      for (int i = 0; i < irobj.getChildren().size(); i++) {
        if (!visit(irobj.getChildren().get(i), irparam.getChildren().get(i))) {
          return false;
        }
      }
      return true;
    } else {
      throw new RuntimeException("Not yet implemented");
    }
  }
}
