/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge;

import cfg.function.PrgFunction;

public class KnowFuncByAddr extends KnowledgeEntry {
  private KnowledgeBase base;

  @Override
  public void init(KnowledgeBase base) {
    this.base = base;
  }

  public PrgFunction findFunction(long addr) {
    for (PrgFunction func : base.getApp().getFunctions()) {
      if (func.getAddr() == addr) {
        return func;
      }
    }
    return null;
  }
}
