/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge;


import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import cfg.IrTraverser;
import cfg.function.PrgFunction;
import cfg.statement.Statement;

/**
 * Knows all statements of a function
 * 
 * @author urs
 * 
 */
public class KnowStatements extends KnowledgeEntry {
  private Map<PrgFunction, Set<Statement>> map;

  @Override
  public void init(KnowledgeBase base) {
    KnowStatementsVisitor visitor = new KnowStatementsVisitor();
    visitor.visit(base.getApp().getFunctions(), null);
    map = visitor.getMap();
  }

  public Set<Statement> getStatements(PrgFunction func) {
    return map.get(func);
  }

}

class KnowStatementsVisitor extends IrTraverser<Void, Set<Statement>> {
  Map<PrgFunction, Set<Statement>> map = new HashMap<PrgFunction, Set<Statement>>();

  public Map<PrgFunction, Set<Statement>> getMap() {
    return map;
  }

  @Override
  protected Void visitPrgFunction(PrgFunction obj, Set<Statement> param) {
    assert (param == null);
    assert (!map.containsKey(obj));
    param = new HashSet<Statement>();
    super.visitPrgFunction(obj, param);
    map.put(obj, param);
    return null;
  }

  @Override
  protected Void visitStatement(Statement obj, Set<Statement> param) {
    if (!obj.isDeleted()) {
      param.add(obj);
    }
    return null;
  }

}
