/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge;


import java.util.HashSet;
import java.util.Set;

import cfg.IrTraverser;
import cfg.expression.CallExpr;
import cfg.expression.CallExprPointer;
import cfg.expression.CallExprUnlinked;
import cfg.expression.Expression;
import cfg.expression.VariableKilled;
import cfg.expression.VariableRef;
import cfg.expression.VariableRefUnlinked;

public class KnowUnlinked extends KnowledgeEntry {
  @Override
  public void init(KnowledgeBase base) {
  }

  public Set<Expression> getUnlinked(Object elem) {
    KnowUnlinkedVisitor visitor = new KnowUnlinkedVisitor();
    visitor.visit(elem, null);
    Set<Expression> res = new HashSet<Expression>();
    res.addAll(visitor.getVarrefStmt());
    res.addAll(visitor.getCall());
    return res;
  }

  public boolean hasUnlinked(Object elem) {
    return !getUnlinked(elem).isEmpty();
  }
}

class KnowUnlinkedVisitor extends IrTraverser<Void, Void> {
  private Set<VariableRef> varrefStmt = new HashSet<VariableRef>();
  private Set<CallExpr>    call       = new HashSet<CallExpr>();

  public Set<VariableRef> getVarrefStmt() {
    return varrefStmt;
  }

  public Set<CallExpr> getCall() {
    return call;
  }

  @Override
  protected Void visitCallExprUnlinked(CallExprUnlinked obj, Void param) {
    call.add(obj);
    return super.visitCallExprUnlinked(obj, null);
  }

  @Override
  protected Void visitCallExprPointer(CallExprPointer obj, Void param) {
    call.add(obj);
    return super.visitCallExprPointer(obj, null);
  }

  @Override
  protected Void visitVariableRefUnlinked(VariableRefUnlinked obj, Void param) {
    varrefStmt.add(obj);
    return super.visitVariableRefUnlinked(obj, null);
  }

  @Override
  protected Void visitVariableKilled(VariableKilled obj, Void param) {
    varrefStmt.add(obj);
    return super.visitVariableKilled(obj, null);
  }
}
