/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge;


import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import cfg.IrTraverser;
import cfg.expression.VariableRefLinked;
import cfg.statement.Statement;
import cfg.variable.ArrayAccess;

public class KnowVarDependency extends KnowledgeEntry {
  private Map<Statement, Set<Statement>> cache = null;

  @Override
  public void init(KnowledgeBase base) {
    KnowVarDependencyVisitor visitor = new KnowVarDependencyVisitor(base);
    visitor.visit(base.getApp().getFunctions(), null);
    cache = visitor.getDepends();
  }

  public Map<Statement, Set<Statement>> getDependencies() {
    return cache;
  }
}

class KnowVarDependencyVisitor extends IrTraverser<Void, Set<Statement>> {
  private KnowOwner                      ko;
  private Map<Statement, Set<Statement>> depends = new HashMap<Statement, Set<Statement>>();

  public KnowVarDependencyVisitor(KnowledgeBase kb) {
    ko = (KnowOwner) kb.getEntry(KnowOwner.class);
  }

  public Map<Statement, Set<Statement>> getDepends() {
    return depends;
  }

  @Override
  protected Void visitVariableArrayAccess(ArrayAccess obj, Set<Statement> param) {
    visit(obj.getIndex(), param);
    return null;
  }

  @Override
  protected Void visitVariableRefLinked(VariableRefLinked obj, Set<Statement> param) {
    param.add(ko.getVarOwner(obj.getReference()));
    return null;
  }

  @Override
  protected Void visitStatement(Statement obj, Set<Statement> param) {
    if (!obj.isDeleted()) {
      assert (param == null);
      param = new HashSet<Statement>();
      super.visitStatement(obj, param);
      depends.put(obj, param);
      param = null;
    }
    return null;
  }

}
