/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge;


import java.util.HashSet;
import java.util.Set;

import cfg.IrTraverser;
import cfg.variable.Array;
import cfg.variable.SsaVariable;
import cfg.variable.Variable;
import cfg.variable.VariableName;

public class KnowVariables extends KnowledgeEntry {
  @Override
  public void init(KnowledgeBase base) {
  }

  public Set<Variable> getVariables(Object elem, VariableName name) {
    KnowVariablesVisitor visitor = new KnowVariablesVisitor(name);
    visitor.visit(elem, null);
    return visitor.getVardef();
  }

  public boolean hasVarDef(Object elem, VariableName name) {
    return !getVariables(elem, name).isEmpty();
  }
}

class KnowVariablesVisitor extends IrTraverser<Void, Void> {
  private Set<Variable> vardef = new HashSet<Variable>();
  private VariableName  name;

  public KnowVariablesVisitor(VariableName name) {
    super();
    this.name = name;
  }

  public Set<Variable> getVardef() {
    return vardef;
  }

  @Override
  protected Void visitSsaVariable(SsaVariable obj, Void param) {
    if (obj.getName().equals(name)) {
      vardef.add(obj);
    }
    return super.visitSsaVariable(obj, param);
  }

  @Override
  protected Void visitArray(Array obj, Void param) {
    if (obj.getName().equals(name)) {
      vardef.add(obj);
    }
    return super.visitArray(obj, param);
  }

}
