/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge;

import java.util.Collection;

public class MemAccess {
  public Object base;
  public long   offset;
  public long   size;

  public static boolean mayOverlap(Collection<MemAccess> a, Collection<MemAccess> b) {
    for (MemAccess ma : a) { // better algorithm possible, but most lists have only one element
      for (MemAccess mb : b) {
        if (mayOverlap(ma, mb)) {
          return true;
        }
      }
    }
    return false;
  }

  public static boolean mayOverlap(MemAccess ma, MemAccess mb) {
    if (ma.base != mb.base) {
      return true;          //TODO is this correct?
    }
    // start of a in range of b?
    if ((ma.offset >= mb.offset) && (ma.offset < mb.offset + mb.size)) {
      return true;
    }
    // end of a in range of b?
    if ((ma.offset + ma.size >= mb.offset) && (ma.offset + ma.size < mb.offset + mb.size)) {
      return true;
    }
    return false;
  }

}
