/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge.memory;


import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import cfg.statement.Statement;

public class MemoryDependencyTraverser extends MemoryWriteTraverser {
  private Map<Statement, Set<Statement>> depends = new HashMap<Statement, Set<Statement>>();

  public Map<Statement, Set<Statement>> getDepends() {
    return depends;
  }

  protected void accessDynamicMemory(boolean write) {
    Set<Statement> writer = memory.getWriter();
    depends.get(stmt).addAll(writer);
    super.accessDynamicMemory(write);
  }

  protected void accessStaticMemory(int offset, boolean write) {
    Statement writer = memory.getWriter(offset);
    if (writer != null) {
      depends.get(stmt).add(writer);
    }
    super.accessStaticMemory(offset, write);
  }

  @Override
  protected Void visitStatement(Statement obj, Boolean param) {
    if (!obj.isDeleted()) {
      depends.put(obj, new HashSet<Statement>());
      super.visitStatement(obj, param);
    }
    return null;
  }

}
