/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package main;

import java.io.File;

import phases.Upcompiler;
import phases.ast.AstTranslator;
import phases.ast.ExprNormalizer;
import phases.ast.PointerReplacer;
import phases.ast.StmtNormalizer;
import phases.ast.TypeReconstruction;
import phases.ast.VariableLinker;
import phases.ast.VariableNamer;
import phases.ast.VariableReduction;
import phases.cfg.ArrayReplacer;
import phases.cfg.ConditionReplacer;
import phases.cfg.Disassembler;
import phases.cfg.FunctionRecovery;
import phases.cfg.FunctionVariableLinker;
import phases.cfg.IoFunctionReplacer;
import phases.cfg.MathReduction;
import phases.cfg.MemoryFuncReplacer;
import phases.cfg.SsaBacktranslator;
import phases.cfg.SsaReduce;
import phases.java.JavaWriter;
import cfg.Application;
import cfg.function.system.SystemFunctions;

public class Main {
  /**
   * @param args
   */
  public static void main(String[] args) {
    if (args.length < 1) {
      System.err.println("Expect exactly one binary name");
      System.exit(-1);
    }

    File filename = new File(args[0]);
    // System.out.println("Disassembly " + filename);

    Upcompiler upcompiler = new Upcompiler();
    Application app = new Application(filename, new SystemFunctions());

    /*
     * // debug printing printCallgraph(filename,app); try { for (PrgFunction func : app.getFunctions()) {
     * VarDependencyGraph.print(func, new Writer(new PrintStream(filename + ".3." + NumPrint.toString(func.getAddr()) +
     * ".dep.gv")), base); } } catch (FileNotFoundException e) { e.printStackTrace(); }
     */

    // ---- read ----
    upcompiler.phase(new Disassembler(upcompiler), app);
    // ---- cfg operations ----
    upcompiler.phase(new FunctionVariableLinker(upcompiler), app);
    upcompiler.phase(new ConditionReplacer(upcompiler), app);
    upcompiler.phase(new FunctionRecovery(upcompiler), app);
    upcompiler.phase(new MathReduction(upcompiler), app);
    upcompiler.phase(new SsaReduce(upcompiler), app);
    upcompiler.phase(new IoFunctionReplacer(upcompiler), app);
    upcompiler.phase(new ArrayReplacer(upcompiler), app);
    upcompiler.phase(new MemoryFuncReplacer(upcompiler), app);
    upcompiler.phase(new SsaBacktranslator(upcompiler), app);
    // ---- ast operations ----
    upcompiler.phase(new AstTranslator(upcompiler), app);
    upcompiler.phase(new VariableLinker(upcompiler), app);
    upcompiler.phase(new StmtNormalizer(upcompiler), app);
    upcompiler.phase(new TypeReconstruction(upcompiler), app);
    upcompiler.phase(new PointerReplacer(upcompiler), app);
    // ---- optimizations ----
    upcompiler.phase(new VariableReduction(upcompiler), app);
    upcompiler.phase(new ExprNormalizer(upcompiler), app);
    upcompiler.phase(new StmtNormalizer(upcompiler), app);
    upcompiler.phase(new VariableNamer(upcompiler), app);
    // ---- write ----
    upcompiler.phase(new JavaWriter(upcompiler), app);

  }

/*  private static void writeProgram(String filename, Ast prg, InfoWriter info) {
    CodeWriter codewriter = new CodeWriter(info);
    PrintStream stream;
    try {
      stream = new PrintStream(filename);
      Writer writer = new Writer(stream);
      codewriter.visit(prg, writer);
      stream.close();
    } catch (FileNotFoundException e) {
      e.printStackTrace();
    }
  }

  private static void printCfg(String filename, Application app) {
    for (Function func : app.getFunctions()) {
      if (!(func instanceof PrgFunction)) {
        continue;
      }
      PrgFunction pfunc = (PrgFunction) func;

      String prefix = filename;
      String sufix = ".gv";
      DotWriter<BasicBlock, BbEdge> writer = new DotSimpleWriter<BasicBlock, BbEdge>(new SimpleLabel(),
          pfunc.getGraph());
      writer.write(prefix + "." + Long.toHexString(pfunc.getAddr()) + sufix);
    }
  }

  private static void printCallgraph(File filename, KnowledgeBase base) {
    KnowCallDst callDst = (KnowCallDst) base.getEntry(KnowCallDst.class);
    DirectedGraph<Function, SimpleEdge<Function>> cg = callDst.getCallgraph();
    String prefix = filename.toString();
    String sufix = ".gv";
    DotWriter<Function, SimpleEdge<Function>> writer = new DotHtmlWriter<Function, SimpleEdge<Function>>(
        new FunctionLabel(prefix, sufix + ".svg"), cg);
    writer.write(prefix + ".callgraph" + sufix);
  }*/

}
