/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.ast;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import cfg.Application;

public class AstTranslator extends Phase {

  public AstTranslator(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "translating to AST representation (meta phase)";
  }

  @Override
  public boolean process(Application app) {
    Structurer strucphase = new Structurer(upcompiler);
    upcompiler.phase(strucphase, app);
    upcompiler.phase(new FunctionLinker(upcompiler, strucphase.getFunctions()), app);
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.AST;
  }

}
