/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.ast;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import ast.dataflow.ExpressionReduction;
import cfg.Application;

public class ExprNormalizer extends Phase {

  public ExprNormalizer(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "simplifying expressions";
  }

  @Override
  public boolean process(Application app) {
    ExpressionReduction.normalize(app.getPrg());
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.AST;
  }

}
