/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.ast;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import ast.traverser.LiveRangeShortener;
import cfg.Application;

public class LiveRangeShortening extends Phase {

  public LiveRangeShortening(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "reducing the live range (preparation for coalescing)";
  }

  @Override
  public boolean process(Application app) {
    LiveRangeShortener.process(app.getKb().getPrg());
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.AST;
  }

}
