/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.ast;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import ast.BlockNormalizer;
import cfg.Application;

public class StmtNormalizer extends Phase {

  public StmtNormalizer(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "Reducing the number of blocks, removing empty statements";
  }

  @Override
  public boolean process(Application app) {
    BlockNormalizer.normalize(app.getPrg());
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.AST;
  }

}
