/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.ast;


import java.util.HashMap;
import java.util.Map;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import ast.PrgFunc;
import cfg.Application;
import cfg.function.PrgFunction;

public class Structurer extends Phase {
  private final Map<Long, ast.Function> functions = new HashMap<Long, ast.Function>();

  public Structurer(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "structuring code";
  }

  @Override
  public boolean process(Application app) {
    app.getPrg().getFunction().add(null);
    int funcnr = 0;
    for (PrgFunction func : app.getFunctions()) {
      PrgFunc nfunc = structuring.Structurer.process(func);
      functions.put(func.getAddr(), nfunc);
      if (func.getAddr() == app.getMainAddr()) {
        nfunc.setName("main");
        app.getPrg().getFunction().set(0, nfunc);
      } else {
        nfunc.setName("func" + funcnr);
        funcnr++;
        app.getPrg().getFunction().add(nfunc);
      }
    }
    return true;
  }

  public final Map<Long, ast.Function> getFunctions() {
    return functions;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.AST;
  }

}
