/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.ast;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import ast.traverser.VariableInserter;
import cfg.Application;

public class VariableLinker extends Phase {

  public VariableLinker(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "Linking variables";
  }

  @Override
  public boolean process(Application app) {
    VariableInserter.process(app.getPrg());
    ast.traverser.VariableLinker.process(app.getPrg());

    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.AST;
  }

}
