/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.ast;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import cfg.Application;

public class VariableReduction extends Phase {

  public VariableReduction(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "reducing number of variables";
  }

  @Override
  public boolean process(Application app) {
    upcompiler.phase(new LiveRangeShortening(upcompiler), app);
    Coalescing coalescer;
    do {
      coalescer = new Coalescing(upcompiler);
      upcompiler.phase(coalescer, app);
    } while (coalescer.getRemoved() > 0);// FIXME fibrec needs this

    app.getKb().clear();
    upcompiler.phase(new CopyPropagator(upcompiler), app);
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.AST;
  }

}
