/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.cfg;


import java.util.Set;

import knowledge.KnowOwner;
import knowledge.KnowUnlinked;
import knowledge.KnowledgeBase;
import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import cfg.Application;
import cfg.expression.Expression;
import cfg.statement.Statement;
import cfg.unlinker.SimpleSsaBacktranslation;
import cfg.unlinker.VariableRenamer;
import cfg.unlinker.VariableUnlinker;

public class SsaBacktranslator extends Phase {

  public SsaBacktranslator(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "getting out of SSA";
  }

  @Override
  public boolean process(Application app) {
    // check
    checkForUnlinked(app.getKb());
    VariableRenamer.rename(app.getFunctions());
    VariableUnlinker.unlink(app.getFunctions());
    SimpleSsaBacktranslation.translate(app.getFunctions());
    return true;
  }

  private static void checkForUnlinked(KnowledgeBase base) {
    KnowUnlinked knowUnlinked = (KnowUnlinked) base.getEntry(KnowUnlinked.class);
    KnowOwner knowOwner = (KnowOwner) base.getEntry(KnowOwner.class);
    Set<Expression> unlinked = knowUnlinked.getUnlinked(base.getApp().getFunctions());
    if (!unlinked.isEmpty()) {
      System.out.println("Unlinked found:");
      for (Expression expr : unlinked) {
        Statement stmt = knowOwner.getExprOwner(expr);
        System.out.print(knowOwner.getBbOwner(knowOwner.getStmtOwner(stmt)));
        System.out.print(": ");
        System.out.print(stmt);
        System.out.println();
      }
      System.out.println();
      throw new RuntimeException("Unlinked found, should not happen");
    }
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.SSA;
  }

}
