/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.cfg;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import reduction.ExpressionReduction;
import reduction.MemoryModelEnforcer;
import reduction.StmtDeleter;
import reduction.UnusedVariableRemover;
import cfg.Application;
import cfg.function.PrgFunction;

public class SsaReduce extends Phase {
  private int removed = 0;

  public SsaReduce(Upcompiler upcompiler) {
    super(upcompiler);
  }

  public final int getRemoved() {
    return removed;
  }

  @Override
  public String getDescription() {
    return "inlining expressions, remove dead stmts";
  }

  @Override
  public boolean process(Application app) {
    for (PrgFunction func : app.getFunctions()) {
      PrgFunction pfunc = (PrgFunction) func;

      MemoryModelEnforcer mme = new MemoryModelEnforcer(app);

      int rem;
      do {
        app.getKb().clear();
        ExpressionReduction.reduce(pfunc, mme, app.getKb());
        app.getKb().clear();

        UnusedVariableRemover.process(pfunc, app.getKb());
        rem = StmtDeleter.process(pfunc, app.getKb());
        removed += rem;
      } while (rem > 0); // TODO why are multiple passes needed (example fibrec)
      assert (StmtDeleter.process(pfunc, app.getKb()) == 0);
    }
    app.getKb().clear();
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.SSA;
  }

}
