/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.java;


import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import ast.Ast;
import cfg.Application;
import codewriter.CodeWriter;
import codewriter.SupportWriter;
import codewriter.Writer;

public class JavaWriter extends Phase {

  public JavaWriter(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "write java files";
  }

  @Override
  public boolean process(Application app) {
    File filename = app.getFile().getAbsoluteFile();
    writeProgram(filename.getParent() + File.separator + app.getPrg().getOutputName() + ".java", app.getPrg());
    SupportWriter.generateFiles(filename.getParent());
    return true;
  }

  private static void writeProgram(String filename, Ast prg) {
    CodeWriter codewriter = new CodeWriter(null);
    PrintStream stream;
    try {
      stream = new PrintStream(filename);
      Writer writer = new Writer(stream);
      codewriter.visit(prg, writer);
      stream.close();
    } catch (FileNotFoundException e) {
      e.printStackTrace();
    }
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.CODE;
  }

}
