/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package reduction;


import java.util.Collection;
import java.util.List;

import cfg.IntConstant;
import cfg.IrElement;
import cfg.IrTraverser;
import cfg.expression.CallExprLinked;
import cfg.expression.CallExprPointer;
import cfg.expression.CallExprUnlinked;
import cfg.expression.CompareExpr;
import cfg.expression.Expression;
import cfg.expression.IfExpr;
import cfg.expression.IntegerExpr;
import cfg.expression.UnaryExpression;
import cfg.expression.VariableKilled;
import cfg.expression.VariableRefLinked;
import cfg.expression.VariableRefUnlinked;
import cfg.function.Function;
import cfg.function.LibFunction;
import cfg.statement.JumpStmt;
import cfg.statement.PhiStmt;
import cfg.variable.ArrayAccess;
import cfg.variable.GlobalVariable;
import cfg.variable.StackVariable;
import cfg.variable.VariablePtrDeref;
import cfg.variable.VariablePtrOf;

public class ExprCopy extends IrTraverser<IrElement, Void> {
  static public Expression copy(Expression expr) {
    ExprCopy copy = new ExprCopy();
    return (Expression) copy.visit(expr, null);
  }

  @Override
  protected IrElement visitFunction(Function obj, Void param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected IrElement visitLibFunction(LibFunction obj, Void param) {
    throw new RuntimeException("Not yet implemented");
  }

  @SuppressWarnings("unchecked")
  @Override
  protected IrElement visitCallExprLinked(CallExprLinked obj, Void param) {
    CallExprLinked call = new CallExprLinked(obj.getFunc());
    call.setParam((List<Expression>) visitList(obj.getParam(), null));
    return call;
  }

  @Override
  protected IrElement visitCallExprUnlinked(CallExprUnlinked obj, Void param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected IrElement visitCallExprPointer(CallExprPointer obj, Void param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected IrElement visitUnaryExpression(UnaryExpression obj, Void param) {
    return new UnaryExpression((Expression) visit(obj.getExpr(), null), obj.getOp());
  }

  @Override
  protected IrElement visitPhiStmt(PhiStmt obj, Void param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected IrElement visitVariableRefUnlinked(VariableRefUnlinked obj, Void param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected VariableRefLinked visitVariableRefLinked(VariableRefLinked obj, Void param) {
    return new VariableRefLinked(obj.getReference());
  }

  @Override
  protected IrElement visitVariableKilled(VariableKilled obj, Void param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected IrElement visitConstant(IntConstant obj, Void param) {
    return new IntConstant(obj.getValue());
  }

  @Override
  protected IrElement visitVariablePtrOf(VariablePtrOf obj, Void param) {
    return new VariablePtrOf((Expression) visit(obj.getExpression(), null));
  }

  @Override
  protected IrElement visitVariableArrayAccess(ArrayAccess obj, Void param) {
    return new ArrayAccess(obj.getBase(), (Expression) visit(obj.getIndex(), null));
  }

  @Override
  protected IrElement visitVariablePtrDeref(VariablePtrDeref obj, Void param) {
    return new VariablePtrDeref((Expression) visit(obj.getExpression(), null));
  }

  @Override
  protected IrElement visitStackVariable(StackVariable obj, Void param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected IrElement visitGlobalVariable(GlobalVariable obj, Void param) {
    return new GlobalVariable(obj.getSegment(), obj.getAddress());
  }

  @Override
  protected IrElement visitIfExpr(IfExpr obj, Void param) {
    return new IfExpr((Expression) visit(obj.getCondition(), null), (Expression) visit(obj.getLeft(), null),
        (Expression) visit(obj.getRight(), null));
  }

  @Override
  protected IrElement visitIntegerExpr(IntegerExpr obj, Void param) {
    return new IntegerExpr((Expression) visit(obj.getLeft(), param), (Expression) visit(obj.getRight(), param),
        obj.getOp());
  }

  @Override
  protected IrElement visitCompareExpr(CompareExpr obj, Void param) {
    return new CompareExpr((Expression) visit(obj.getLeft(), param), (Expression) visit(obj.getRight(), param),
        obj.getOperand());
  }

  @Override
  protected IrElement visitJumpStmt(JumpStmt obj, Void param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected IrElement visitCollection(Collection<IrElement> obj, Void param) {
    throw new RuntimeException("Not yet implemented");
  }

  private List<? extends IrElement> visitList(List<? extends IrElement> param, Object object) {
    try {
      @SuppressWarnings("unchecked")
      List<IrElement> res = param.getClass().newInstance();
      for (IrElement elem : param) {
        res.add(visit(elem, null));
      }
      return res;
    } catch (InstantiationException e) {
      e.printStackTrace();
    } catch (IllegalAccessException e) {
      e.printStackTrace();
    }
    return null;
  }

}
