/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package reduction;


import java.util.Collection;

import cfg.BooleanConstant;
import cfg.IntConstant;
import cfg.IrElement;
import cfg.IrTraverser;
import cfg.expression.CallExprLinked;
import cfg.expression.CallExprPointer;
import cfg.expression.CallExprUnlinked;
import cfg.expression.CompareExpr;
import cfg.expression.Expression;
import cfg.expression.IfExpr;
import cfg.expression.IntegerExpr;
import cfg.expression.UnaryExpression;
import cfg.expression.VariableKilled;
import cfg.expression.VariableRefLinked;
import cfg.expression.VariableRefUnlinked;
import cfg.variable.ArrayAccess;
import cfg.variable.GlobalVariable;
import cfg.variable.StackVariable;
import cfg.variable.VariablePtrDeref;
import cfg.variable.VariablePtrOf;

public class InliningCostCalculator extends IrTraverser<Integer, Void> {
  static final int FUCKING_EXPENSIV = Integer.MAX_VALUE;
  static final int CALL_COST        = 10;               // TODO use brain to find adequate value
  static final int MATHOP_COST      = 1;

  static public int getCost(Expression expr) {
    InliningCostCalculator icc = new InliningCostCalculator();
    Integer res = icc.visit(expr, null);
    assert (res != null);
    return res;
  }

  @Override
  protected Integer visitVariableRefUnlinked(VariableRefUnlinked obj, Void param) {
    throw new RuntimeException("Can not calculate cost of unlinked variable:" + obj);
  }

  @Override
  protected Integer visitVariableKilled(VariableKilled obj, Void param) {
    throw new RuntimeException("Can not calculate cost of killed variable:" + obj);
  }

  @Override
  protected Integer visitVariableRefLinked(VariableRefLinked obj, Void param) {
    return 0;
  }

  @Override
  protected Integer visitBooleanConstant(BooleanConstant obj, Void param) {
    return 0;
  }

  @Override
  protected Integer visitConstant(IntConstant obj, Void param) {
    return 0;
  }

  @Override
  protected Integer visitVariableArrayAccess(ArrayAccess obj, Void param) {
    return visit(obj.getIndex(), null);
  }

  @Override
  protected Integer visitVariablePtrDeref(VariablePtrDeref obj, Void param) {
    return visit(obj.getExpression(), null);
  }

  @Override
  protected Integer visitVariablePtrOf(VariablePtrOf obj, Void param) {
    return visit(obj.getExpression(), null);
  }

  @Override
  protected Integer visitStackVariable(StackVariable obj, Void param) {
    return 0;
  }

  @Override
  protected Integer visitGlobalVariable(GlobalVariable obj, Void param) {
    return 0;
  }

  @Override
  protected Integer visitIfExpr(IfExpr obj, Void param) {
    return MATHOP_COST + visit(obj.getCondition(), null) + visit(obj.getLeft(), null) + visit(obj.getRight(), null);
  }

  @Override
  protected Integer visitIntegerExpr(IntegerExpr obj, Void param) {
    return MATHOP_COST + visit(obj.getLeft(), null) + visit(obj.getRight(), null);
  }

  @Override
  protected Integer visitCompareExpr(CompareExpr obj, Void param) {
    return MATHOP_COST + visit(obj.getLeft(), null) + visit(obj.getRight(), null);
  }

  @Override
  protected Integer visitUnaryExpression(UnaryExpression obj, Void param) {
    return visit(obj.getExpr(), null);
  }

  @Override
  protected Integer visitCallExprLinked(CallExprLinked obj, Void param) {
    return CALL_COST + visit(obj.getParam(), null);
  }

  @Override
  protected Integer visitCallExprUnlinked(CallExprUnlinked obj, Void param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Integer visitCallExprPointer(CallExprPointer obj, Void param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Integer visitCollection(Collection<IrElement> obj, Void param) {
    int res = 0;
    for (Object itr : obj) {
      res += visit(itr, param);
    }
    return res;
  }

}
