/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package structuring;


import java.util.Collection;

import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.function.FunctionGraph;

public class Merger {
  private FunctionGraph graph;

  public Merger(FunctionGraph graph) {
    super();
    this.graph = graph;
  }

  public void merge(Collection<BasicBlock> vertices, Collection<BbEdge> edges, BasicBlock newv) {
    int origNrOfEdges = graph.edgeSet().size();

    graph.removeAllVertices(vertices);
    graph.addVertex(newv);
    graph.updateEdges();

    int newNrOfEdges = graph.edgeSet().size();
    assert (origNrOfEdges == newNrOfEdges + edges.size());
  }

}
