/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package structuring.matcher;


import java.util.ArrayList;
import java.util.Map;

import util.StmtUtil;
import ast.statement.BlockStmt;
import ast.statement.Statement;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.statement.JumpStmt;
import cfg.statement.NopStmt;

/*
 *  0
 *  |
 *  1
 */

public class CompositionMatcher implements Pattern {
  private ArrayList<ArrayList<BasicBlock>> vertices = new ArrayList<ArrayList<BasicBlock>>();
  private ArrayList<ArrayList<BbEdge>>     BbEdges  = new ArrayList<ArrayList<BbEdge>>();


  public ArrayList<ArrayList<BbEdge>> edges() {
    return BbEdges;
  }


  public int internalEdges() {
    return 1;
  }


  public ArrayList<ArrayList<BasicBlock>> vertices() {
    return vertices;
  }


  public int internalVertices() {
    return 2;
  }

  public boolean match(BasicBlock entry) {
    ArrayList<BbEdge> outlist = new ArrayList<BbEdge>(entry.getOutlist());
    if (outlist.size() != 1) {
      return false;
    }
    BbEdge BbEdge = outlist.get(0);
    BasicBlock exit = BbEdge.getDst();
    if (entry == exit) {
      return false;
    }
    if (exit.getInlist().size() != 1) { // TODO allow this if insertion of goto is needed
      return false;
    }
    addToBbEdges(BbEdge);
    addToVertices(entry, exit);
    return !vertices.isEmpty();
  }

  private void addToVertices(BasicBlock entry, BasicBlock exit) {
    ArrayList<BasicBlock> list = new ArrayList<BasicBlock>(2);
    list.add(entry);
    list.add(exit);
    vertices.add(list);
  }

  private void addToBbEdges(BbEdge BbEdge) {
    ArrayList<BbEdge> list = new ArrayList<BbEdge>(1);
    list.add(BbEdge);
    BbEdges.add(list);
  }


  public cfg.statement.Statement getNewJump(ArrayList<BasicBlock> config) {
    cfg.statement.Statement stmt = config.get(1).getCode().getLast();
    if (stmt instanceof JumpStmt) {
      return stmt;
    } else {
      return new NopStmt();
    }
  }


  public Statement getStmtCode(ArrayList<BasicBlock> config, Map<BasicBlock, Statement> mapping) {
    assert (vertices.contains(config));
    assert (StmtUtil.getNrOfStmts(config.get(0).getCode()) == 1);
    assert (StmtUtil.getNrOfStmts(config.get(1).getCode()) <= 1);
    BlockStmt block = new BlockStmt();
    block.addCode(mapping.get(config.get(0)));
    block.addCode(mapping.get(config.get(1)));
    return block;
  }

}
