/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package structuring.matcher;


import java.util.ArrayList;
import java.util.Map;

import ast.expression.BooleanConstant;
import ast.statement.Statement;
import ast.statement.WhileStmt;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.statement.NopStmt;

/*
 *  0
 *  |\
 *  +-+
 */

public class EndlessLoop implements Pattern {
  private ArrayList<ArrayList<BasicBlock>> vertices = new ArrayList<ArrayList<BasicBlock>>();
  private ArrayList<ArrayList<BbEdge>>     edges    = new ArrayList<ArrayList<BbEdge>>();


  public ArrayList<ArrayList<BbEdge>> edges() {
    return edges;
  }


  public int internalEdges() {
    return 1;
  }


  public ArrayList<ArrayList<BasicBlock>> vertices() {
    return vertices;
  }


  public int internalVertices() {
    return 1;
  }

  public boolean match(BasicBlock body) {
    ArrayList<BbEdge> outlist = new ArrayList<BbEdge>(body.getOutlist());
    if (outlist.size() != 1) {
      return false;
    }

    BbEdge back = outlist.get(0);
    BasicBlock next = back.getDst();

    if (next != body) {
      return false;
    }

    addToVertices(body);
    addToEdges(back);

    return true;
  }

  private void addToVertices(BasicBlock body) {
    ArrayList<BasicBlock> list = new ArrayList<BasicBlock>(1);
    list.add(body);
    vertices.add(list);
  }

  private void addToEdges(BbEdge back) {
    ArrayList<BbEdge> list = new ArrayList<BbEdge>(1);
    list.add(back);
    edges.add(list);
  }


  public cfg.statement.Statement getNewJump(ArrayList<BasicBlock> config) {
    return new NopStmt();
  }


  public Statement getStmtCode(ArrayList<BasicBlock> config, Map<BasicBlock, Statement> mapping) {
    assert (vertices.contains(config));
    return new WhileStmt(new BooleanConstant(true), mapping.get(config.get(0)));
  }

}
