/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/**
 * Iterates over all combinations from the numbers 0 to base-1 over all digits, leaving the combinations with two or
 * more equal numbers out.
 * 
 * @author urs
 * 
 */

public class Combinations implements Iterator<ArrayList<Integer>> {
  private ArrayList<Integer> state;
  private int                base;

  public Combinations(int digits, int base) {
    super();
    if (digits <= base) {
      state = new ArrayList<Integer>(digits);
      for (int i = 0; i < digits; i++) {
        state.add(digits - 1 - i);
      }
    } else {
      state = null;
    }
    this.base = base;
  }

  public boolean hasNext() {
    return state != null;
  }

  public ArrayList<Integer> next() {
    ArrayList<Integer> res = new ArrayList<Integer>(state);
    do {
      if (!incComb()) {
        state = null;
        break;
      }
    } while (hasEqualComb());
    return res;
  }

  public void remove() {
    next();
  }

  private boolean hasEqualComb() {
    Set<Integer> found = new HashSet<Integer>();
    for (int i : state) {
      if (found.contains(i)) {
        return true;
      }
      found.add(i);
    }
    return false;
  }

  private boolean incComb() {
    for (int i = 0; i < state.size(); i++) {
      int val = state.get(i);
      val++;
      if (val >= base) {
        state.set(i, 0);
      } else {
        state.set(i, val);
        return true;
      }
    }
    return false;
  }

}
