/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package util;


import java.util.List;

import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.statement.JumpStmt;
import cfg.statement.Statement;

public class StmtUtil {
  public static JumpStmt toJump(Statement stmt) {
    if (stmt.isDeleted()) {
      throw new RuntimeException("Basic block contains no statements");
    }
    if (!(stmt instanceof JumpStmt)) {
      throw new RuntimeException("Basic block contains no jump");
    }
    return (JumpStmt) stmt;
  }

  public static int getNrOfStmts(List<Statement> stmts) {
    int res = 0;
    for (Statement stmt : stmts) {
      if (!stmt.isDeleted()) {
        res++;
      }
    }
    return res;
  }

  public static int getEdgeValue(BasicBlock src, BasicBlock dst) {
    for (BbEdge e : src.getOutlist()) {
      if (e.getDst() == dst) {
        return e.getNr();
      }
    }
    throw new RuntimeException("No edge found");
  }

}
