/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package util;

import java.util.Iterator;

public class SymbItrStream<T> implements SymbolStream<T> {
	private Iterator<T>		stream;
	private T				next;
	
	public SymbItrStream(Iterator<T> stream) {
		super();
		this.stream = stream;
		consume();
	}

	public T peek(){
		return next;
	}
	
	public T consume(){
		T	ret = next;
		if( stream.hasNext() ){
			next = stream.next();
		} else {
			next = null;
		}
		return ret;
	}
	
	public boolean hasMore(){
		return next != null;
	}

}
