/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package util;

import java.util.List;

public class SymbolIndexStream<T> implements SymbolStream<T> {
	private List<T> stream;
	private int idx;

	public SymbolIndexStream(List<T> stream, int idx) {
		super();
		this.stream = stream;
		this.idx = idx;
	}

	public T peek() {
		return stream.get(idx);
	}

	public T consume() {
		T res = peek();
		idx++;
		return res;
	}

	public boolean hasMore() {
		return idx < stream.size();
	}

}
