/*
 * Decompiled with CFR 0.152.
 */
package ast;

import ast.Ast;
import ast.expression.Expression;
import ast.statement.BlockStmt;
import ast.statement.NullStmt;
import ast.statement.Statement;
import ast.traverser.AstStatementTraverser;
import ast.traverser.AstTraverser;
import ast.variable.Variable;
import java.util.ArrayList;

public class BlockNormalizer
extends AstStatementTraverser<Void> {
    public static void normalize(Ast ast) {
        AstTraverser<Void> astTraverser = new AstTraverser<Void>(new BlockNormalizer());
        astTraverser.visit(ast, null);
    }

    @Override
    public Expression visit(Expression expression, Void void_) {
        return expression;
    }

    @Override
    public Variable visit(Variable variable, Void void_) {
        return variable;
    }

    @Override
    protected Statement visitBlockStmt(BlockStmt blockStmt, Void void_) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        for (Statement statement : blockStmt.getBlock()) {
            if ((statement = this.visit(statement, null)) instanceof BlockStmt) {
                arrayList.addAll(((BlockStmt)statement).getBlock());
                continue;
            }
            if (statement instanceof NullStmt) continue;
            arrayList.add(statement);
        }
        switch (arrayList.size()) {
            case 0: {
                return new NullStmt();
            }
            case 1: {
                return (Statement)arrayList.get(0);
            }
        }
        return new BlockStmt(arrayList);
    }
}

