/*
 * Decompiled with CFR 0.152.
 */
package ast.dataflow;

import ast.expression.ArithmeticExpr;
import ast.expression.CompareExpr;
import ast.expression.Expression;
import ast.expression.IntConstant;
import ast.expression.IntegerOp;
import ast.expression.UnaryExpression;
import ast.expression.UnaryOp;
import ast.traverser.AstExpressionTraverser;

class ExprReduction
extends AstExpressionTraverser<Void> {
    ExprReduction() {
    }

    private static Expression evaluate(IntegerOp integerOp, IntConstant intConstant, IntConstant intConstant2) {
        switch (integerOp) {
            case Add: {
                return new IntConstant(intConstant.getValue() + intConstant2.getValue());
            }
            case Sub: {
                return new IntConstant(intConstant.getValue() - intConstant2.getValue());
            }
            case Mul: {
                return new IntConstant(intConstant.getValue() * intConstant2.getValue());
            }
            case Div: {
                return new IntConstant(intConstant.getValue() / intConstant2.getValue());
            }
            case ShiftLeft: {
                return new IntConstant(intConstant.getValue() << (int)intConstant2.getValue());
            }
            case ShiftRight: {
                return new IntConstant(intConstant.getValue() >> (int)intConstant2.getValue());
            }
            case And: {
                return new IntConstant(intConstant.getValue() & intConstant2.getValue());
            }
            case Or: {
                return new IntConstant(intConstant.getValue() | intConstant2.getValue());
            }
            case Xor: {
                return new IntConstant(intConstant.getValue() ^ intConstant2.getValue());
            }
        }
        throw new RuntimeException("Unhandled operation: " + (Object)((Object)integerOp));
    }

    @Override
    protected Expression visitArithmeticExpr(ArithmeticExpr arithmeticExpr, Void void_) {
        Expression expression;
        IntConstant intConstant;
        arithmeticExpr = (ArithmeticExpr)super.visitArithmeticExpr(arithmeticExpr, void_);
        IntConstant intConstant2 = null;
        IntConstant intConstant3 = null;
        if (arithmeticExpr.getLeft() instanceof IntConstant) {
            intConstant2 = (IntConstant)arithmeticExpr.getLeft();
        }
        if (arithmeticExpr.getRight() instanceof IntConstant) {
            intConstant3 = (IntConstant)arithmeticExpr.getRight();
        }
        if (intConstant2 != null && intConstant3 != null) {
            return ExprReduction.evaluate(arithmeticExpr.getOp(), intConstant2, intConstant3);
        }
        if (intConstant2 == null && intConstant3 == null) {
            return arithmeticExpr;
        }
        if (intConstant2 != null) {
            intConstant = intConstant2;
            expression = arithmeticExpr.getRight();
        } else {
            intConstant = intConstant3;
            expression = arithmeticExpr.getLeft();
        }
        switch (arithmeticExpr.getOp()) {
            case Add: 
            case Xor: {
                switch ((int)intConstant.getValue()) {
                    case 0: {
                        return expression;
                    }
                }
                return arithmeticExpr;
            }
            case And: {
                switch ((int)intConstant.getValue()) {
                    case 0: {
                        return new IntConstant(0L);
                    }
                }
                return arithmeticExpr;
            }
            case Div: {
                switch ((int)intConstant.getValue()) {
                    case 1: {
                        return expression;
                    }
                }
                return arithmeticExpr;
            }
            case Mul: {
                switch ((int)intConstant.getValue()) {
                    case 0: {
                        return new IntConstant(0L);
                    }
                    case 1: {
                        return expression;
                    }
                }
                return arithmeticExpr;
            }
            case Sub: 
            case ShiftLeft: 
            case ShiftRight: 
            case Or: {
                return arithmeticExpr;
            }
        }
        throw new RuntimeException("Unhandled integer expression: " + (Object)((Object)arithmeticExpr.getOp()));
    }

    @Override
    protected Expression visitUnaryExpression(UnaryExpression unaryExpression, Void void_) {
        unaryExpression.setExpr(this.visit(unaryExpression.getExpr(), null));
        if (unaryExpression.getOp() == UnaryOp.Not && unaryExpression.getExpr() instanceof CompareExpr) {
            CompareExpr compareExpr = (CompareExpr)unaryExpression.getExpr();
            compareExpr.setOperand(compareExpr.getOperand().getInverse());
            return compareExpr;
        }
        return unaryExpression;
    }
}

