/*
 * Decompiled with CFR 0.152.
 */
package ast.traverser;

import ast.expression.ArithmeticExpr;
import ast.expression.BooleanConstant;
import ast.expression.CallExpr;
import ast.expression.CompareExpr;
import ast.expression.Expression;
import ast.expression.FunctionRef;
import ast.expression.FunctionRefLinked;
import ast.expression.FunctionRefUnlinked;
import ast.expression.IfExpr;
import ast.expression.IntConstant;
import ast.expression.NullConstExpr;
import ast.expression.NullExpr;
import ast.expression.StringConstant;
import ast.expression.UnaryExpression;
import ast.expression.VariablePtrDeref;
import ast.expression.VariablePtrOf;
import ast.variable.ArrayAccess;
import ast.variable.Variable;
import ast.variable.VariableRef;
import ast.variable.VariableRefLinked;
import ast.variable.VariableRefUnlinked;
import java.util.List;

public class AstExpressionTraverser<P> {
    protected FunctionRef visit(FunctionRef functionRef, P p) {
        if (functionRef instanceof FunctionRefLinked) {
            return this.visitFunctionRefLinked((FunctionRefLinked)functionRef, p);
        }
        if (functionRef instanceof FunctionRefUnlinked) {
            return this.visitFunctionRefUnlinked((FunctionRefUnlinked)functionRef, p);
        }
        throw new RuntimeException("Unhandled class: " + functionRef.getClass());
    }

    protected FunctionRef visitFunctionRefUnlinked(FunctionRefUnlinked functionRefUnlinked, P p) {
        return functionRefUnlinked;
    }

    protected FunctionRef visitFunctionRefLinked(FunctionRefLinked functionRefLinked, P p) {
        return functionRefLinked;
    }

    public Variable visit(Variable variable, P p) {
        return variable;
    }

    public final void visit(List<Expression> list, P p) {
        for (int i = 0; i < list.size(); ++i) {
            Expression expression = list.get(i);
            expression = this.visit(expression, p);
            list.set(i, expression);
        }
    }

    public Expression visit(Expression expression, P p) {
        if (expression instanceof CompareExpr) {
            return this.visitCompareExpr((CompareExpr)expression, p);
        }
        if (expression instanceof ArithmeticExpr) {
            return this.visitArithmeticExpr((ArithmeticExpr)expression, p);
        }
        if (expression instanceof IfExpr) {
            return this.visitIfExpr((IfExpr)expression, p);
        }
        if (expression instanceof VariableRefUnlinked) {
            return this.visitVariableRefUnlinked((VariableRefUnlinked)expression, p);
        }
        if (expression instanceof VariableRefLinked) {
            return this.visitVariableRefLinked((VariableRefLinked)expression, p);
        }
        if (expression instanceof IntConstant) {
            return this.visitConstant((IntConstant)expression, p);
        }
        if (expression instanceof StringConstant) {
            return this.visitStringConstant((StringConstant)expression, p);
        }
        if (expression instanceof BooleanConstant) {
            return this.visitBooleanConstant((BooleanConstant)expression, p);
        }
        if (expression instanceof UnaryExpression) {
            return this.visitUnaryExpression((UnaryExpression)expression, p);
        }
        if (expression instanceof CallExpr) {
            return this.visitCallExpr((CallExpr)expression, p);
        }
        if (expression instanceof VariablePtrDeref) {
            return this.visitVariablePtrDeref((VariablePtrDeref)expression, p);
        }
        if (expression instanceof VariablePtrOf) {
            return this.visitVariablePtrOf((VariablePtrOf)expression, p);
        }
        if (expression instanceof ArrayAccess) {
            return this.visitArrayAccess((ArrayAccess)expression, p);
        }
        if (expression instanceof NullConstExpr) {
            return this.visitNullConstExpr((NullConstExpr)expression, p);
        }
        if (expression instanceof NullExpr) {
            return this.visitNullExpr((NullExpr)expression, p);
        }
        throw new RuntimeException("Unhandled class: " + expression.getClass());
    }

    protected Expression visitNullExpr(NullExpr nullExpr, P p) {
        return nullExpr;
    }

    protected Expression visitNullConstExpr(NullConstExpr nullConstExpr, P p) {
        return nullConstExpr;
    }

    protected Expression visitArrayAccess(ArrayAccess arrayAccess, P p) {
        arrayAccess.setBase((VariableRef)this.visit(arrayAccess.getBase(), p));
        arrayAccess.setIndex(this.visit(arrayAccess.getIndex(), p));
        return arrayAccess;
    }

    protected Expression visitVariablePtrOf(VariablePtrOf variablePtrOf, P p) {
        variablePtrOf.setVar((ArrayAccess)this.visit(variablePtrOf.getVar(), p));
        return variablePtrOf;
    }

    protected Expression visitVariablePtrDeref(VariablePtrDeref variablePtrDeref, P p) {
        variablePtrDeref.setExpr(this.visit(variablePtrDeref.getExpr(), p));
        return variablePtrDeref;
    }

    protected Expression visitCallExpr(CallExpr callExpr, P p) {
        callExpr.setFunction(this.visit(callExpr.getFunction(), p));
        this.visit(callExpr.getParam(), p);
        return callExpr;
    }

    protected Expression visitUnaryExpression(UnaryExpression unaryExpression, P p) {
        unaryExpression.setExpr(this.visit(unaryExpression.getExpr(), p));
        return unaryExpression;
    }

    protected Expression visitVariableRefUnlinked(VariableRefUnlinked variableRefUnlinked, P p) {
        return variableRefUnlinked;
    }

    protected Expression visitVariableRefLinked(VariableRefLinked variableRefLinked, P p) {
        return variableRefLinked;
    }

    protected Expression visitBooleanConstant(BooleanConstant booleanConstant, P p) {
        return booleanConstant;
    }

    protected Expression visitConstant(IntConstant intConstant, P p) {
        return intConstant;
    }

    protected Expression visitStringConstant(StringConstant stringConstant, P p) {
        return stringConstant;
    }

    protected Expression visitIfExpr(IfExpr ifExpr, P p) {
        ifExpr.setCondition(this.visit(ifExpr.getCondition(), p));
        ifExpr.setLeft(this.visit(ifExpr.getLeft(), p));
        ifExpr.setRight(this.visit(ifExpr.getRight(), p));
        return ifExpr;
    }

    protected Expression visitArithmeticExpr(ArithmeticExpr arithmeticExpr, P p) {
        arithmeticExpr.setLeft(this.visit(arithmeticExpr.getLeft(), p));
        arithmeticExpr.setRight(this.visit(arithmeticExpr.getRight(), p));
        return arithmeticExpr;
    }

    protected Expression visitCompareExpr(CompareExpr compareExpr, P p) {
        compareExpr.setLeft(this.visit(compareExpr.getLeft(), p));
        compareExpr.setRight(this.visit(compareExpr.getRight(), p));
        return compareExpr;
    }
}

