/*
 * Decompiled with CFR 0.152.
 */
package ast.traverser;

import ast.expression.CallExpr;
import ast.expression.Expression;
import ast.statement.AssignmentStmt;
import ast.statement.BlockStmt;
import ast.statement.CallStmt;
import ast.statement.CaseStmt;
import ast.statement.DoWhile;
import ast.statement.IfStmt;
import ast.statement.NullStmt;
import ast.statement.RetStmt;
import ast.statement.Statement;
import ast.statement.VarDef;
import ast.statement.WhileStmt;
import ast.variable.Variable;
import java.util.List;

public abstract class AstStatementTraverser<P> {
    public abstract Expression visit(Expression var1, P var2);

    public abstract Variable visit(Variable var1, P var2);

    public final void visit(List<Statement> list, P p) {
        for (int i = 0; i < list.size(); ++i) {
            Statement statement = list.get(i);
            statement = this.visit(statement, p);
            list.set(i, statement);
        }
    }

    public Statement visit(Statement statement, P p) {
        if (statement instanceof AssignmentStmt) {
            return this.visitAssignmentStmt((AssignmentStmt)statement, p);
        }
        if (statement instanceof RetStmt) {
            return this.visitRetStmt((RetStmt)statement, p);
        }
        if (statement instanceof DoWhile) {
            return this.visitDoWhileStmt((DoWhile)statement, p);
        }
        if (statement instanceof WhileStmt) {
            return this.visitWhileStmt((WhileStmt)statement, p);
        }
        if (statement instanceof BlockStmt) {
            return this.visitBlockStmt((BlockStmt)statement, p);
        }
        if (statement instanceof IfStmt) {
            return this.visitIfStmt((IfStmt)statement, p);
        }
        if (statement instanceof CallStmt) {
            return this.visitCallStmt((CallStmt)statement, p);
        }
        if (statement instanceof CaseStmt) {
            return this.visitCaseStmt((CaseStmt)statement, p);
        }
        if (statement instanceof VarDef) {
            return this.visitVarDef((VarDef)statement, p);
        }
        if (statement instanceof NullStmt) {
            return this.visitNullStmt((NullStmt)statement, p);
        }
        throw new RuntimeException("Unhandled class: " + statement.getClass());
    }

    protected Statement visitNullStmt(NullStmt nullStmt, P p) {
        return nullStmt;
    }

    protected Statement visitVarDef(VarDef varDef, P p) {
        varDef.setVariable(this.visit(varDef.getVariable(), p));
        return varDef;
    }

    protected Statement visitCallStmt(CallStmt callStmt, P p) {
        callStmt.setCall((CallExpr)this.visit(callStmt.getCall(), p));
        return callStmt;
    }

    protected Statement visitIfStmt(IfStmt ifStmt, P p) {
        ifStmt.setCondition(this.visit(ifStmt.getCondition(), p));
        ifStmt.setThenBranch(this.visit(ifStmt.getThenBranch(), p));
        ifStmt.setElseBranch(this.visit(ifStmt.getElseBranch(), p));
        return ifStmt;
    }

    protected Statement visitBlockStmt(BlockStmt blockStmt, P p) {
        this.visit(blockStmt.getBlock(), p);
        return blockStmt;
    }

    protected Statement visitWhileStmt(WhileStmt whileStmt, P p) {
        whileStmt.setCondition(this.visit(whileStmt.getCondition(), p));
        whileStmt.setBody(this.visit(whileStmt.getBody(), p));
        return whileStmt;
    }

    protected Statement visitDoWhileStmt(DoWhile doWhile, P p) {
        doWhile.setBody(this.visit(doWhile.getBody(), p));
        doWhile.setCondition(this.visit(doWhile.getCondition(), p));
        return doWhile;
    }

    protected Statement visitCaseStmt(CaseStmt caseStmt, P p) {
        caseStmt.setCondition(this.visit(caseStmt.getCondition(), p));
        for (int n : caseStmt.getOption().keySet()) {
            Statement statement = caseStmt.getOption().get(n);
            statement = this.visit(statement, p);
            caseStmt.getOption().put(n, statement);
        }
        caseStmt.setOther(this.visit(caseStmt.getOther(), p));
        return caseStmt;
    }

    protected Statement visitRetStmt(RetStmt retStmt, P p) {
        retStmt.setRetval(this.visit(retStmt.getRetval(), p));
        return retStmt;
    }

    protected Statement visitAssignmentStmt(AssignmentStmt assignmentStmt, P p) {
        assignmentStmt.setSource(this.visit(assignmentStmt.getSource(), p));
        assignmentStmt.setDestination(this.visit(assignmentStmt.getDestination(), p));
        return assignmentStmt;
    }
}

