/*
 * Decompiled with CFR 0.152.
 */
package ast.traverser;

import ast.Ast;
import ast.Function;
import ast.PrgFunc;
import ast.Program;
import ast.expression.Expression;
import ast.statement.Statement;
import ast.traverser.AstStatementTraverser;
import java.util.List;

public class AstTraverser<P> {
    private AstStatementTraverser<P> stmt;

    public AstTraverser(AstStatementTraverser<P> astStatementTraverser) {
        this.stmt = astStatementTraverser;
    }

    public AstStatementTraverser<P> getStmt() {
        return this.stmt;
    }

    public final void visitList(List<PrgFunc> list, P p) {
        for (int i = 0; i < list.size(); ++i) {
            PrgFunc prgFunc = list.get(i);
            prgFunc = (PrgFunc)this.visit(prgFunc, p);
            list.set(i, prgFunc);
        }
    }

    public Ast visit(Ast ast, P p) {
        if (ast == null) {
            throw new RuntimeException("obj is null");
        }
        if (ast instanceof Statement) {
            return this.stmt.visit((Statement)ast, p);
        }
        if (ast instanceof Expression) {
            return this.stmt.visit((Expression)ast, p);
        }
        if (ast instanceof Function) {
            return this.visitFunction((Function)ast, p);
        }
        if (ast instanceof Program) {
            return this.visitProgram((Program)ast, p);
        }
        throw new RuntimeException("Unhandled class: " + ast.getClass());
    }

    protected Ast visitProgram(Program program, P p) {
        this.visitList(program.getFunction(), p);
        return program;
    }

    protected Ast visitFunction(Function function, P p) {
        if (function instanceof PrgFunc) {
            return this.visitPrgFunc((PrgFunc)function, p);
        }
        throw new RuntimeException("Unhandled class: " + function.getClass());
    }

    protected Ast visitPrgFunc(PrgFunc prgFunc, P p) {
        for (int i = 0; i < prgFunc.getParam().size(); ++i) {
            prgFunc.getParam().set(i, this.stmt.visit(prgFunc.getParam().get(i), p));
        }
        prgFunc.setBody(this.stmt.visit(prgFunc.getBody(), p));
        return prgFunc;
    }
}

