/*
 * Decompiled with CFR 0.152.
 */
package ast.traverser;

import ast.expression.Expression;
import ast.expression.IntConstant;
import ast.expression.NullConstExpr;
import ast.traverser.AstExpressionTraverser;
import ast.type.Type;
import knowledge.KnowTypes;

class ExprPointerNullConstReplacer
extends AstExpressionTraverser<Void> {
    KnowTypes kt;

    public ExprPointerNullConstReplacer(KnowTypes knowTypes) {
        this.kt = knowTypes;
    }

    @Override
    protected Expression visitConstant(IntConstant intConstant, Void void_) {
        Type type = this.kt.getTypeOf(intConstant);
        if (type == Type.Pointer) {
            if (intConstant.getValue() != 0L) {
                throw new RuntimeException("Can not handle pointer constant different than 0 (is " + intConstant.getValue() + ")");
            }
            return new NullConstExpr();
        }
        return intConstant;
    }
}

