/*
 * Decompiled with CFR 0.152.
 */
package ast.traverser;

import ast.expression.ArithmeticExpr;
import ast.expression.CallExpr;
import ast.expression.CompareExpr;
import ast.expression.Expression;
import ast.expression.IfExpr;
import ast.expression.VariablePtrDeref;
import ast.expression.VariablePtrOf;
import ast.traverser.AstExpressionTraverser;
import ast.variable.ArrayAccess;
import ast.variable.Variable;
import ast.variable.VariableRefLinked;
import graph.TestGraph;
import java.util.Set;

class ExprVarDependency
extends AstExpressionTraverser<Set<Variable>> {
    private TestGraph<Variable> dependency = new TestGraph();

    ExprVarDependency() {
    }

    @Override
    public Variable visit(Variable variable, Set<Variable> set) {
        assert (!this.dependency.vertexSet().contains(variable));
        this.dependency.addVertex(variable);
        return variable;
    }

    public void addDependencies(Variable variable, Set<Variable> set) {
        for (Variable variable2 : set) {
            this.dependency.addEdge((Object)variable, (Object)variable2);
        }
    }

    public final TestGraph<Variable> getDependency() {
        return this.dependency;
    }

    @Override
    public Expression visit(Expression expression, Set<Variable> set) {
        if (set != null) {
            super.visit(expression, set);
        }
        return expression;
    }

    @Override
    protected Expression visitArrayAccess(ArrayAccess arrayAccess, Set<Variable> set) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Expression visitVariablePtrOf(VariablePtrOf variablePtrOf, Set<Variable> set) {
        return variablePtrOf;
    }

    @Override
    protected Expression visitVariablePtrDeref(VariablePtrDeref variablePtrDeref, Set<Variable> set) {
        return variablePtrDeref;
    }

    @Override
    protected Expression visitCallExpr(CallExpr callExpr, Set<Variable> set) {
        return callExpr;
    }

    @Override
    protected Expression visitVariableRefLinked(VariableRefLinked variableRefLinked, Set<Variable> set) {
        set.add(variableRefLinked.getReference());
        return variableRefLinked;
    }

    @Override
    protected Expression visitIfExpr(IfExpr ifExpr, Set<Variable> set) {
        this.visit(ifExpr.getLeft(), set);
        this.visit(ifExpr.getRight(), set);
        return ifExpr;
    }

    @Override
    protected Expression visitArithmeticExpr(ArithmeticExpr arithmeticExpr, Set<Variable> set) {
        return super.visitArithmeticExpr(arithmeticExpr, set);
    }

    @Override
    protected Expression visitCompareExpr(CompareExpr compareExpr, Set<Variable> set) {
        return super.visitCompareExpr(compareExpr, set);
    }
}

