/*
 * Decompiled with CFR 0.152.
 */
package ast.traverser;

import ast.LibFuncs;
import ast.expression.ArithmeticExpr;
import ast.expression.CallExpr;
import ast.expression.Expression;
import ast.expression.FunctionRefLinked;
import ast.expression.VariablePtrDeref;
import ast.statement.AssignmentStmt;
import ast.statement.CallStmt;
import ast.statement.Statement;
import ast.traverser.AstStatementTraverser;
import ast.traverser.PointerAccessRemoverExpr;
import ast.traverser.PointerExprMatcher;
import ast.type.Type;
import ast.variable.Variable;
import java.util.ArrayList;
import knowledge.KnowTypes;

class PointerAccessRemoverStmt
extends AstStatementTraverser<KnowTypes> {
    private PointerAccessRemoverExpr exptrav = new PointerAccessRemoverExpr();

    PointerAccessRemoverStmt() {
    }

    @Override
    public Expression visit(Expression expression, KnowTypes knowTypes) {
        return this.exptrav.visit(expression, knowTypes);
    }

    @Override
    public Variable visit(Variable variable, KnowTypes knowTypes) {
        return this.exptrav.visit(variable, knowTypes);
    }

    @Override
    protected Statement visitAssignmentStmt(AssignmentStmt assignmentStmt, KnowTypes knowTypes) {
        if (assignmentStmt.getDestination() instanceof VariablePtrDeref) {
            Expression expression = this.visit(assignmentStmt.getSource(), knowTypes);
            ArrayList<Expression> arrayList = new ArrayList<Expression>(2);
            PointerExprMatcher pointerExprMatcher = new PointerExprMatcher(((VariablePtrDeref)assignmentStmt.getDestination()).getExpr(), knowTypes);
            arrayList.add(pointerExprMatcher.getPointer());
            arrayList.add(pointerExprMatcher.getDisplacement());
            arrayList.add(expression);
            return new CallStmt(new CallExpr(new FunctionRefLinked(LibFuncs.ptrSetValue), arrayList));
        }
        if (assignmentStmt.getSource() instanceof ArithmeticExpr && knowTypes.getTypeOf(assignmentStmt.getDestination()) == Type.Pointer) {
            ArrayList<Expression> arrayList = new ArrayList<Expression>(2);
            PointerExprMatcher pointerExprMatcher = new PointerExprMatcher(assignmentStmt.getSource(), knowTypes);
            arrayList.add(pointerExprMatcher.getPointer());
            arrayList.add(pointerExprMatcher.getDisplacement());
            assignmentStmt.setSource(new CallExpr(new FunctionRefLinked(LibFuncs.ptrCopy), arrayList));
            return assignmentStmt;
        }
        return super.visitAssignmentStmt(assignmentStmt, knowTypes);
    }
}

